/**
 * Contains pre-generated point sets.
 * 
 * David Wisnosky
 */

let preGenPointSetsSelection = document.getElementById('preGeneratedPointSets');
preGenPointSetsSelection.addEventListener('change', getPreGeneratedPointSet);

var preGeneratedPointSets = new Map();

preGeneratedPointSets.set('circle', 
                        [[3.0, 0.0],
                        [2.9057494833858932, 0.7460696614945643],
                        [2.628920040131591, 1.445261022305146],
                        [2.1869058822642344, 2.053641317786066],
                        [1.60748038493699, 2.532983776506045],
                        [0.9270509831248424, 2.8531695488854605],
                        [0.18837155858793986, 2.9940801852848145],
                        [-0.5621439437571745, 2.9468617521860656],
                        [-1.2773378746952182, 2.7144811573980583],
                        [-1.9122719692460688, 2.311539728327368],
                        [-2.427050983124842, 1.7633557568774196],
                        [-2.7893294576647545, 1.104373658054033],
                        [-2.9763441039434335, 0.3759997006929123],
                        [-2.9763441039434335, -0.37599970069291294],
                        [-2.7893294576647536, -1.104373658054035],
                        [-2.4270509831248415, -1.76335575687742],
                        [-1.9122719692460688, -2.311539728327368],
                        [-1.2773378746952164, -2.714481157398059],
                        [-0.5621439437571739, -2.946861752186066],
                        [0.18837155858794116, -2.9940801852848145],
                        [0.9270509831248417, -2.853169548885461],
                        [1.60748038493699, -2.532983776506045],
                        [2.1869058822642358, -2.053641317786065],
                        [2.628920040131591, -1.445261022305146],
                        [2.9057494833858937, -0.7460696614945634]]);

preGeneratedPointSets.set('archimedeanSpiral', 
                        [[1.0, 0.0],
                        [1.3173373636064734, 0.9571016183905645],
                        [0.6973392021200407, 2.1461893821917757],
                        [-0.8915003059925871, 2.743755815140087],
                        [-2.842298471301051, 2.065050716684839],
                        [-4.141592653589793, 5.07198818659093316],
                        [-3.8589392097641033, -2.8036834488810207],
                        [-1.6681447214827747, -5.134021546933331],
                        [1.8623058253553195, -5.731587979881644],
                        [5.38390031745868, -3.9116325471752957],
                        [7.283185307179586, -1.783865914806902515],
                        [6.400541055921731, 4.6502652793714825],
                        [2.6389502408455097, 8.121853711674886],
                        [-2.833111344718051, 8.7194201446232],
                        [-7.925502163616309, 5.758214377665754],
                        [-10.42477796076938, 3.83000128844342815],
                        [-8.942142902079366, -6.496847109861931],
                        [-3.6097557602082455, -11.109685876416442],
                        [3.803916864080782, -11.707252309364756],
                        [10.467104009773939, -7.604796208156213],
                        [13.566370614359172, -6.64560493956866915],
                        [11.483744748236996, 8.343428940352387],
                        [4.580561279570957, 14.097518041158008],
                        [-4.774722383443485, 14.69508447410632],
                        [-13.008705855931563, 9.451378038646673],
                        [-16.707963267948966, 1.023067686818262614],
                        [-14.02534659439463, -10.190010770842838],
                        [-5.551366798933718, -17.08535020589955],
                        [5.745527902806241, -17.68291663884787],
                        [15.550307702089192, -11.297959869137133],
                        [19.84955592153876, -1.4585217074285314],
                        [16.566948440552263, 12.036592601333291],
                        [6.522172318296456, 20.073182370641106],
                        [-6.716333422168971, 20.67074880358943],
                        [-18.091909548246818, 13.144541699627593],
                        [-22.991148575128552, 1.97092255578766914],
                        [-19.108550286709896, -13.883174431823743],
                        [-7.492977837659194, -23.06101453538266],
                        [7.687138941531697, -23.658580968330984],
                        [20.633511394404447, -14.991123530118056],
                        [26.132741228718345, -2.560270231895679314],
                        [21.650152132867582, 15.729756262314117],
                        [8.463783357021933, 26.048846700124212],
                        [-8.657944460894425, 26.646413133072542],
                        [-23.175113240562133, 16.837705360608435],
                        [-29.274333882308138, 3.226564735752561414],
                        [-24.19175397902522, -17.57633809280456],
                        [-9.434588876384673, -29.036678864865767],
                        [9.628749980257151, -29.6342452978141],
                        [25.716715086719766, -18.684287191098893]]);

preGeneratedPointSets.set('grid', 
                        [[-8, 8],
                        [-4, 8],
                        [0, 8],
                        [4, 8],
                        [8, 8],
                        [-8, 4],
                        [-4, 4],
                        [0, 4],
                        [4, 4],
                        [8, 4],
                        [-8, 0],
                        [-4, 0],
                        [0, 0],
                        [4, 0],
                        [8, 0],
                        [-8, -4],
                        [-4, -4],
                        [0, -4],
                        [4, -4],
                        [8, -4],
                        [-8, -8],
                        [-4, -8],
                        [0, -8],
                        [4, -8],
                        [8, -8]]);

function getPreGeneratedPointSet() {

    if (!editPointsSelection.checked){
        return;
    }

    resetAll();

    newPointSet = preGeneratedPointSets.get(preGenPointSetsSelection.value);
    
    updatePointTextBox(newPointSet);

    plotScale();
}